# AdsThatSell App (PHP SaaS) — Deploy Notes

Upload this folder to: **adsthatsell.com/app** (or unzip into `public_html/app`)

## 1) Update configs (required)
Edit these files:

- `app/config/app.php`
- `app/config/db.php`
- `app/config/openai.php`
- `app/config/bunny.php`

## 2) Ensure permissions
- `app/uploads/` writable by PHP (755 or 775 depending on server)
- `app/logs/` writable by PHP

## 3) Database
Import your schema (already created). Ensure `plans`, `styles`, `style_variants` have rows.

## 4) Create first admin user
- Visit `/app/signup.php` and create an account.
- Then in DB set `users.role='admin'` for that user if you want admin later.

## 5) Cron jobs (recommended)
- Trash purge (daily):
  `php /path/to/public_html/app/tools/purge_trash.php`
- Monthly credit grant (optional if using Stripe webhooks):
  `php /path/to/public_html/app/tools/grant_monthly_credits.php`

## Notes
- This build is synchronous generation (no worker). For higher volume, move OpenAI calls into a queue worker.
- This build uses a credit ledger (auditable). Credits are debited before generation and auto-refunded on hard failure.
