<?php
require __DIR__ . '/_init.php';
$pdo = db();

// Get trashed assets for user to delete from Bunny
$stmt = $pdo->prepare("SELECT ga.id, ga.storage_key
                       FROM generation_assets ga
                       JOIN generations g ON g.id=ga.generation_id
                       WHERE g.user_id=? AND ga.deleted_at IS NULL AND ga.trashed_at IS NOT NULL
                       LIMIT 1000");
$stmt->execute([(int)$user['id']]);
$rows = $stmt->fetchAll();

foreach ($rows as $r) {
  if (!empty($r['storage_key'])) {
    bunny_delete((string)$r['storage_key']);
  }
}

// Mark deleted
$pdo->prepare("UPDATE generation_assets ga
               JOIN generations g ON g.id=ga.generation_id
               SET ga.deleted_at=?
               WHERE g.user_id=? AND ga.deleted_at IS NULL AND ga.trashed_at IS NOT NULL")
    ->execute([now_utc(), (int)$user['id']]);

json_response(['ok'=>true,'deleted'=>count($rows)]);
