function openai_edit_images(string $prompt, string $image_path, string $size, string $quality, int $n): array {
  $cfg = openai_cfg();
  $key = $cfg['api_key'] ?? '';
  if (!$key) throw new RuntimeException('OPENAI_API_KEY_NOT_SET');

  $url = rtrim($cfg['base_url'], '/') . '/images/edits';

  $n = max(1, min(8, $n));
  if (!in_array($size, ['1024x1024','1024x1536','1536x1024'], true)) $size = '1024x1024';
  if (!in_array($quality, ['low','medium','high','auto'], true)) $quality = 'medium';

  $post = [
    'model' => $cfg['image_model'] ?? 'gpt-image-1.5',
    'prompt' => $prompt,
    'n' => $n,
    'size' => $size,
    'quality' => $quality,
    'image' => new CURLFile($image_path),
  ];

  $ch = curl_init($url);
  curl_setopt_array($ch, [
    CURLOPT_POST => true,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => (int)($cfg['timeout_seconds'] ?? 120),
    CURLOPT_HTTPHEADER => [
      'Authorization: Bearer ' . $key,
    ],
    CURLOPT_POSTFIELDS => $post,
  ]);

  $raw = curl_exec($ch);
  $err = curl_error($ch);
  $code = (int)curl_getinfo($ch, CURLINFO_HTTP_CODE);
  curl_close($ch);

  if ($raw === false) throw new RuntimeException("OPENAI_EDIT_CURL_ERROR: $err");

  $json = json_decode($raw, true);
  if (!is_array($json)) throw new RuntimeException("OPENAI_EDIT_BAD_JSON (HTTP $code): " . substr($raw,0,250));
  if ($code < 200 || $code >= 300) {
    $msg = $json['error']['message'] ?? ("HTTP $code");
    throw new RuntimeException("OPENAI_EDIT_ERROR: $msg");
  }

  $out = [];
  foreach (($json['data'] ?? []) as $item) {
    if (!empty($item['b64_json'])) {
      $bin = base64_decode($item['b64_json'], true);
      if ($bin !== false) $out[] = $bin;
    } elseif (!empty($item['url'])) {
      $b = file_get_contents($item['url']);
      if ($b !== false) $out[] = $b;
    }
  }
  return $out;
}
