<?php
require __DIR__ . '/_init.php';

$pdo = db();

// latest generation for user (non-trashed)
$stmt = $pdo->prepare("SELECT id FROM generations WHERE user_id=? AND deleted_at IS NULL ORDER BY id DESC LIMIT 1");
$stmt->execute([(int)$user['id']]);
$g = $stmt->fetch();
if (!$g) json_response(['ok'=>true,'assets'=>[],'copy'=>[]]);

$gen_id = (int)$g['id'];

$assets = $pdo->prepare("SELECT id, variant_label, public_url FROM generation_assets
                         WHERE generation_id=? AND deleted_at IS NULL AND trashed_at IS NULL
                         ORDER BY id ASC");
$assets->execute([$gen_id]);
$a = $assets->fetchAll();

$copy = $pdo->prepare("SELECT copy_type, variant_index, full_text FROM generation_copy
                       WHERE generation_id=? ORDER BY variant_index ASC");
$copy->execute([$gen_id]);
$c = $copy->fetchAll();

json_response(['ok'=>true,'assets'=>$a,'copy'=>$c]);
