<?php
require __DIR__ . '/_init.php';
$body = read_json_body();
$asset_id = (int)($body['asset_id'] ?? 0);
if ($asset_id <= 0) json_response(['ok'=>false,'error'=>'asset_id required'], 400);

$pdo = db();

// Ensure asset belongs to user
$stmt = $pdo->prepare("SELECT ga.id FROM generation_assets ga
                       JOIN generations g ON g.id=ga.generation_id
                       WHERE ga.id=? AND g.user_id=? AND ga.deleted_at IS NULL LIMIT 1");
$stmt->execute([$asset_id, (int)$user['id']]);
if (!$stmt->fetch()) json_response(['ok'=>false,'error'=>'Not found'], 404);

// Save
$pdo->prepare("INSERT INTO saved_ads (user_id, generation_asset_id, created_at) VALUES (?,?,?)")
    ->execute([(int)$user['id'], $asset_id, now_utc()]);

json_response(['ok'=>true]);
