<?php
require __DIR__ . '/_init.php';
$body = read_json_body();
$asset_id = (int)($body['asset_id'] ?? 0);
if ($asset_id <= 0) json_response(['ok'=>false,'error'=>'asset_id required'], 400);

$app = require __DIR__ . '/../config/app.php';
$days = (int)($app['trash_retention_days'] ?? 30);

$pdo = db();
$stmt = $pdo->prepare("UPDATE generation_assets ga
                       JOIN generations g ON g.id=ga.generation_id
                       SET ga.trashed_at=?, ga.purge_after=?
                       WHERE ga.id=? AND g.user_id=? AND ga.deleted_at IS NULL");
$stmt->execute([now_utc(), purge_after_days($days), $asset_id, (int)$user['id']]);

json_response(['ok'=>true]);
