<?php
require __DIR__ . '/_init.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  json_response(['ok'=>false,'error'=>'POST required'], 405);
}

if (empty($_FILES['file']) || !is_uploaded_file($_FILES['file']['tmp_name'])) {
  json_response(['ok'=>false,'error'=>'No file uploaded'], 400);
}

$f = $_FILES['file'];
$mime = mime_content_type($f['tmp_name']) ?: 'application/octet-stream';
$bytes = file_get_contents($f['tmp_name']);
if ($bytes === false || strlen($bytes) < 1000) {
  json_response(['ok'=>false,'error'=>'Bad upload'], 400);
}

// Store in Bunny (keep under uploads/)
$ext = 'jpg';
if (str_contains($mime, 'png')) $ext = 'png';
$storage_key = "uploads/" . (int)$user['id'] . "/" . time() . "_" . bin2hex(random_bytes(4)) . "." . $ext;
$url = bunny_upload_bytes($storage_key, $bytes, $mime);

// Save to DB uploads table
$pdo = db();
$pdo->prepare("INSERT INTO uploads (user_id, kind, original_filename, mime_type, bytes, storage_provider, storage_key, public_url, created_at)
               VALUES (?,?,?,?,?,?,?,?,?)")
    ->execute([
      (int)$user['id'],
      'product_image',
      (string)($f['name'] ?? ''),
      $mime,
      (int)($f['size'] ?? 0),
      'bunny',
      $storage_key,
      $url,
      now_utc()
    ]);

$id = (int)$pdo->lastInsertId();
json_response(['ok'=>true,'upload_id'=>$id,'public_url'=>$url]);
