<?php
require __DIR__ . '/includes/bootstrap.php';
$user = require_login();

$page_title = 'Create Ad';
$active = 'create';
require __DIR__ . '/includes/header.php';
require __DIR__ . '/includes/topbar.php';
?>
<main class="workspace">
  <aside class="panel left">
    <div class="panelTitle">Create Facebook Ad</div>

    <div class="field">
      <div class="label">Product / Service</div>
      <input id="product" placeholder="e.g. 10×20 Storage Shed" />
    </div>

    <div class="field">
      <div class="label">Main Offer</div>
      <input id="offer" placeholder="e.g. $0 Down • Delivery Included" />
    </div>

    <div class="row">
      <div class="field">
        <div class="label">Objective</div>
        <select id="objective">
          <option>Leads</option>
          <option>Clicks</option>
          <option>Sales</option>
          <option>Messages</option>
        </select>
      </div>
      <div class="field">
        <div class="label">Placement</div>
        <select id="placement">
          <option>Facebook Feed</option>
          <option>Instagram Feed</option>
          <option>Stories / Reels</option>
        </select>
      </div>
    </div>

    <div class="field">
      <div class="label">CTA</div>
      <input id="cta" placeholder="e.g. Message Us" />
    </div>

    <div class="btnRow">
      <button class="btn" id="generateBtn">Generate</button>
    </div>
    <div class="hint" id="costHint">Generates 4 ads · Costs 4 credits</div>

    <div class="switchRow">
      <div class="labelTxt">Generate Copy</div>
      <div class="switch" id="copySwitch" role="switch" aria-checked="false"></div>
    </div>

    <button class="linkBtn" id="openAdvanced">Advanced Options</button>

    <div class="creditsWrap">
      <div class="creditsTop"><span>Tip</span><strong style="color:#fff;">Upload product images later</strong></div>
      <div style="color:var(--subtle);font-weight:900;font-size:12px;line-height:1.45;">
        This build is production-ready backend wiring. Add brand/logo/image panels next.
      </div>
    </div>
  </aside>

  <section class="canvas">
    <div class="canvasHeader">
      <div><h1 id="viewTitle">Generated Ads</h1></div>

      <div class="topControls">
        <div class="viewTabs" role="tablist" aria-label="View">
          <button class="vtab active" id="tabAds" role="tab" aria-selected="true">Ads <span class="count" id="countAds">0</span></button>
          <button class="vtab" id="tabCopy" role="tab" aria-selected="false">Copy <span class="count" id="countCopy">0</span></button>
          <button class="vtab" id="tabTrash" role="tab" aria-selected="false">Trash <span class="count" id="countTrash">0</span></button>
        </div>

        <div class="tabs" role="tablist" aria-label="Preview size">
          <button class="tab active" role="tab" aria-selected="true">1:1</button>
          <button class="tab" role="tab" aria-selected="false">4:5</button>
          <button class="tab" role="tab" aria-selected="false">9:16</button>
        </div>
      </div>
    </div>

    <div id="viewAds">
      <div class="grid" id="adsGrid"></div>
    </div>

    <div id="viewCopy" style="display:none;">
      <div class="copyWrap">
        <div class="copyToolbar">
          <div class="left">
            <label>Copy Type</label>
            <select id="copyType">
              <option selected>Facebook Ad Copy (Primary + Headline)</option>
              <option>Facebook Post Copy (Short + Long)</option>
            </select>
            <span class="pillMini" id="copyHint">Objective: Leads</span>
          </div>
          <div class="right">
            <button class="btnGhost" id="regenCopyBtn" type="button">Regenerate Copy</button>
          </div>
        </div>
        <div id="copyList"></div>
      </div>
    </div>

    <div id="viewTrash" style="display:none;">
      <div class="copyToolbar" style="margin-bottom:12px;">
        <div class="left">
          <label>Trash</label>
          <span class="pillMini">Recover within <?= (int)((require __DIR__ . '/config/app.php')['trash_retention_days'] ?? 30) ?> days</span>
        </div>
        <div class="right">
          <button class="btnGhost" id="emptyTrashBtn" type="button">Empty Trash</button>
        </div>
      </div>
      <div class="grid" id="trashGrid"></div>
    </div>
  </section>

  <aside class="panel right">
    <div class="panelTitle">Style</div>
    <div class="styleList">
      <div class="styleItem active"><div class="left"><div class="check"><span class="tick"></span></div>Flash Sale</div></div>
      <div class="styleItem"><div class="left"><div class="check"><span class="tick"></span></div>Clean Product</div></div>
      <div class="styleItem"><div class="left"><div class="check"><span class="tick"></span></div>Trust / Authority</div></div>
      <div class="styleItem"><div class="left"><div class="check"><span class="tick"></span></div>Marketplace / Ugly</div></div>
      <div class="styleItem"><div class="left"><div class="check"><span class="tick"></span></div>Local Service</div></div>
      <div class="styleItem"><div class="left"><div class="check"><span class="tick"></span></div>Before / After</div></div>
    </div>

    <div style="margin-top:12px;">
      <div class="panelTitle">Variant</div>
      <div class="variantGrid">
        <button class="variantBtn">V1</button>
        <button class="variantBtn active">V2</button>
        <button class="variantBtn">V3</button>
      </div>
    </div>

    <button class="linkBtn" id="openAdvancedRight" type="button">Advanced Options</button>
  </aside>
</main>

<?php require __DIR__ . '/includes/drawer.php'; ?>
<?php require __DIR__ . '/includes/toast.php'; ?>
<?php require __DIR__ . '/includes/footer.php'; ?>
