<?php
// app/includes/auth.php
declare(strict_types=1);

function current_user(): ?array {
  if (!empty($_SESSION['user_id'])) {
    $pdo = db();
    $stmt = $pdo->prepare("SELECT id,email,name,role,status,default_style_id,default_style_variant_id,default_objective,default_placement,default_copy_type FROM users WHERE id=? LIMIT 1");
    $stmt->execute([ (int)$_SESSION['user_id'] ]);
    $u = $stmt->fetch();
    if ($u && $u['status'] === 'active') return $u;
  }
  return null;
}

function require_login(): array {
  $u = current_user();
  if (!$u) {
    header('Location: ' . app_base() . '/login.php');
    exit;
  }
  return $u;
}

function login_user(int $user_id): void {
  session_regenerate_id(true);
  $_SESSION['user_id'] = $user_id;
}

function logout_user(): void {
  $_SESSION = [];
  if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
      $params["path"], $params["domain"], $params["secure"], $params["httponly"]
    );
  }
  session_destroy();
}
