<?php
// app/includes/bootstrap.php
declare(strict_types=1);

ini_set('display_errors', '0');
ini_set('log_errors', '1');
ini_set('error_log', __DIR__ . '/../logs/php_error.log');


require_once __DIR__ . '/../includes/bunny.php';
require_once __DIR__ . '/../includes/openai.php';

// Load /home/<user>/.env into getenv() (safe: file is outside web root)
$envPath = '/home/adsthatsell/.env';
 // /home/adsthatsell/.env
if (file_exists($envPath)) {
  foreach (file($envPath, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES) as $line) {
    $line = trim($line);
    if ($line === '' || str_starts_with($line, '#')) continue;
    $parts = explode('=', $line, 2);
    if (count($parts) !== 2) continue;
    $k = trim($parts[0]);
    $v = trim($parts[1]);
    if ($k !== '' && getenv($k) === false) {
      putenv("$k=$v");
      $_ENV[$k] = $v;
    }
  }
}



$app = require __DIR__ . '/../config/app.php';

date_default_timezone_set($app['timezone'] ?? 'UTC');



session_name($app['session_name'] ?? 'adsthatsell_sess');
session_start();

require_once __DIR__ . '/db.php';
require_once __DIR__ . '/csrf.php';
require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/credits.php';
require_once __DIR__ . '/openai.php';
require_once __DIR__ . '/bunny.php';
require_once __DIR__ . '/utils.php';


function app_base(): string {
  $cfg = require __DIR__ . '/../config/app.php';
  return $cfg['base_path'] ?? '/app';
}
