<?php
// app/includes/csrf.php
declare(strict_types=1);

function csrf_token(): string {
  $app = require __DIR__ . '/../config/app.php';
  $key = $app['csrf_key'] ?? 'adsthatsell_csrf';
  if (empty($_SESSION[$key])) {
    $_SESSION[$key] = bin2hex(random_bytes(32));
  }
  return $_SESSION[$key];
}

function csrf_verify_or_die(): void {
  $app = require __DIR__ . '/../config/app.php';
  $key = $app['csrf_key'] ?? 'adsthatsell_csrf';
  $token = $_POST['csrf'] ?? ($_SERVER['HTTP_X_CSRF_TOKEN'] ?? '');
  if (!is_string($token) || !hash_equals($_SESSION[$key] ?? '', $token)) {
    http_response_code(403);
    echo 'CSRF validation failed';
    exit;
  }
}
