<?php
// app/includes/db.php
declare(strict_types=1);

function db(): PDO {
  static $pdo = null;
  if ($pdo instanceof PDO) return $pdo;

  $cfg = require __DIR__ . '/../config/db.php';
  $dsn = sprintf('mysql:host=%s;dbname=%s;charset=%s', $cfg['host'], $cfg['db'], $cfg['charset'] ?? 'utf8mb4');
  $pdo = new PDO($dsn, $cfg['user'], $cfg['pass'], $cfg['options'] ?? []);
  return $pdo;
}
