<?php
// app/includes/drawer.php
?>
<div class="drawerOverlay" id="drawerOverlay" aria-hidden="true">
  <div class="drawer" role="dialog" aria-modal="true" aria-label="Advanced Options">
    <div class="drawerTop">
      <div class="ttl">Advanced Options</div>
      <button class="closeX" id="closeDrawer" aria-label="Close" type="button">
        <svg width="16" height="16" viewBox="0 0 24 24" fill="none">
          <path d="M6 6l12 12M18 6L6 18" stroke="#fff" stroke-width="2" stroke-linecap="round"/>
        </svg>
      </button>
    </div>

    <div class="drawerSection">
      <div class="panelTitle" style="margin-top:0;">Generation</div>
      <div class="kv">
        <span>Generation Size</span>
        <select id="genSize">
          <option selected>Square (1024×1024)</option>
          <option>Portrait (1024×1536)</option>
          <option>Landscape (1536×1024)</option>
        </select>
      </div>
      <div class="kv">
        <span>Quality</span>
        <select id="quality">
          <option>low</option>
          <option selected>medium</option>
          <option>high</option>
          <option>auto</option>
        </select>
      </div>
      <div class="kv">
        <span>Variations</span>
        <select id="variations">
          <option>2</option>
          <option selected>4</option>
          <option>6</option>
          <option>8</option>
        </select>
      </div>
    </div>

    <div class="drawerSection">
      <div class="panelTitle" style="margin-top:0;">Copy</div>
      <div class="kv">
        <span>Copy Variants</span>
        <select id="copyVariants">
          <option>2</option>
          <option selected>3</option>
          <option>5</option>
        </select>
      </div>
      <div class="kv">
        <span>Copy Tone</span>
        <select id="copyTone">
          <option selected>Direct response</option>
          <option>Friendly</option>
          <option>Professional</option>
          <option>Story-based</option>
        </select>
      </div>
    </div>

    <button class="btn" id="saveAdvanced" type="button">Done</button>
    <div class="hint">Saved locally for your session.</div>
  </div>
</div>
