<?php
// app/includes/topbar.php
declare(strict_types=1);
$active = $active ?? 'create';
$app = require __DIR__ . '/../config/app.php';

$balance = wallet_balance((int)$user['id']);
?>
<header class="topbar">
  <div class="brand">
    <div class="logoMark" aria-hidden="true">
      <svg width="18" height="18" viewBox="0 0 24 24" fill="none">
        <path d="M4 17.5c3.2-7.7 9.1-11.3 16-12.8" stroke="#E10600" stroke-width="2.2" stroke-linecap="round"/>
        <path d="M9 19c2.4-5.2 6.4-8.2 11-9.4" stroke="#fff" stroke-opacity=".9" stroke-width="2.2" stroke-linecap="round"/>
        <path d="M14 20.2c1.2-2.8 3.1-4.4 6-5.2" stroke="#E10600" stroke-width="2.2" stroke-linecap="round"/>
      </svg>
    </div>
    <div class="brandName">AdsThat<span class="sell">Sell</span></div>
  </div>

  <nav class="nav" aria-label="Primary">
    <a class="<?= $active==='create'?'active':'' ?>" href="<?= htmlspecialchars($app['base_path'] ?? '/app') ?>/create.php">Create Ad</a>
    <a class="<?= $active==='my_ads'?'active':'' ?>" href="<?= htmlspecialchars($app['base_path'] ?? '/app') ?>/my_ads.php">My Ads</a>
    <a class="<?= $active==='usage'?'active':'' ?>" href="<?= htmlspecialchars($app['base_path'] ?? '/app') ?>/usage.php">Usage</a>
  </nav>

  <div class="topbarRight">
    <div class="pill" title="Credits remaining">
      <span class="dot"></span>
      <strong style="color:#fff;font-weight:1000;"><?= (int)$balance ?></strong>
      <span>Credits</span>
    </div>

    <div class="user" aria-label="User menu">
      <div class="avatar"><?= htmlspecialchars(strtoupper(substr($user['name'] ?: $user['email'],0,1))) ?></div>
      <div class="name"><?= htmlspecialchars($user['name'] ?: $user['email']) ?></div>
      <a class="logoutLink" href="<?= htmlspecialchars($app['base_path'] ?? '/app') ?>/logout.php" title="Logout">Logout</a>
    </div>
  </div>
</header>
