<?php
// app/includes/utils.php
declare(strict_types=1);

function json_response(array $data, int $code = 200): void {
  http_response_code($code);
  header('Content-Type: application/json; charset=utf-8');
  echo json_encode($data, JSON_UNESCAPED_SLASHES);
  exit;
}

function read_json_body(): array {
  $raw = file_get_contents('php://input');
  if (!$raw) return [];
  $data = json_decode($raw, true);
  return is_array($data) ? $data : [];
}

function require_post_json(): array {
  if ($_SERVER['REQUEST_METHOD'] !== 'POST') json_response(['ok'=>false,'error'=>'POST required'], 405);
  return read_json_body();
}

function now_utc(): string {
  return gmdate('Y-m-d H:i:s');
}

function purge_after_days(int $days): string {
  return gmdate('Y-m-d H:i:s', time() + ($days * 86400));
}
