<?php
require __DIR__ . '/includes/bootstrap.php';

if (current_user()) {
  header('Location: ' . app_base() . '/create.php');
  exit;
}

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_verify_or_die();
  $email = trim((string)($_POST['email'] ?? ''));
  $pass  = (string)($_POST['password'] ?? '');

  if ($email === '' || $pass === '') {
    $error = 'Email and password are required.';
  } else {
    $pdo = db();
    $stmt = $pdo->prepare("SELECT id,password_hash,status FROM users WHERE email=? LIMIT 1");
    $stmt->execute([$email]);
    $u = $stmt->fetch();
    if (!$u || $u['status'] !== 'active' || empty($u['password_hash']) || !password_verify($pass, $u['password_hash'])) {
      $error = 'Invalid login.';
    } else {
      login_user((int)$u['id']);
      header('Location: ' . app_base() . '/create.php');
      exit;
    }
  }
}

$page_title = 'Login';
require __DIR__ . '/includes/header.php';
?>
<header class="topbar">
  <div class="brand">
    <div class="logoMark" aria-hidden="true">
      <svg width="18" height="18" viewBox="0 0 24 24" fill="none">
        <path d="M4 17.5c3.2-7.7 9.1-11.3 16-12.8" stroke="#E10600" stroke-width="2.2" stroke-linecap="round"/>
        <path d="M9 19c2.4-5.2 6.4-8.2 11-9.4" stroke="#fff" stroke-opacity=".9" stroke-width="2.2" stroke-linecap="round"/>
        <path d="M14 20.2c1.2-2.8 3.1-4.4 6-5.2" stroke="#E10600" stroke-width="2.2" stroke-linecap="round"/>
      </svg>
    </div>
    <div class="brandName">AdsThat<span class="sell">Sell</span></div>
  </div>
</header>

<div class="authWrap">
  <form class="authCard" method="post" action="">
    <h1>Login</h1>
    <p>Access your ad generator dashboard.</p>

    <?php if ($error): ?>
      <div class="alert"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <input type="hidden" name="csrf" value="<?= htmlspecialchars(csrf_token()) ?>">

    <div class="field">
      <div class="label">Email</div>
      <input name="email" type="email" autocomplete="email" required>
    </div>

    <div class="field">
      <div class="label">Password</div>
      <input name="password" type="password" autocomplete="current-password" required>
    </div>

    <div class="authActions">
      <button class="btn" type="submit">Login</button>
      <a href="<?= htmlspecialchars(app_base()) ?>/signup.php">Create account</a>
    </div>
  </form>
</div>

<?php require __DIR__ . '/includes/footer.php'; ?>
