<?php
require __DIR__ . '/includes/bootstrap.php';
$user = require_login();
$page_title = 'My Ads';
$active = 'my_ads';
require __DIR__ . '/includes/header.php';
require __DIR__ . '/includes/topbar.php';

$pdo = db();
$stmt = $pdo->prepare("SELECT sa.id, sa.title, ga.public_url, ga.variant_label, sa.created_at
                       FROM saved_ads sa
                       JOIN generation_assets ga ON ga.id = sa.generation_asset_id
                       WHERE sa.user_id=? AND sa.deleted_at IS NULL
                       ORDER BY sa.id DESC
                       LIMIT 200");
$stmt->execute([(int)$user['id']]);
$rows = $stmt->fetchAll();
?>
<main class="workspace" style="grid-template-columns: 1fr;">
  <section class="canvas">
    <div class="canvasHeader">
      <h1>My Ads</h1>
      <div class="topControls">
        <span class="pillMini"><?= count($rows) ?> saved</span>
      </div>
    </div>

    <div class="grid">
      <?php foreach($rows as $r): ?>
        <div class="adCard">
          <div class="adPreview">
            <div class="badge"><?= htmlspecialchars($r['title'] ?: $r['variant_label'] ?: 'Saved') ?></div>
            <img src="<?= htmlspecialchars($r['public_url']) ?>" alt="Saved" style="width:100%;height:100%;object-fit:cover;">
          </div>
          <div class="adActions">
            <div class="iconRow">
              <a class="iconBtn" href="<?= htmlspecialchars($r['public_url']) ?>" target="_blank" title="Download" aria-label="Download">
                <svg width="16" height="16" viewBox="0 0 24 24" fill="none">
                  <path d="M12 3v10" stroke="#b0b0b0" stroke-width="1.8" stroke-linecap="round"/>
                  <path d="M8 11l4 4 4-4" stroke="#b0b0b0" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round"/>
                  <path d="M4 20h16" stroke="#b0b0b0" stroke-width="1.8" stroke-linecap="round"/>
                </svg>
              </a>
            </div>
            <span class="pillMini"><?= htmlspecialchars(substr($r['created_at'],0,10)) ?></span>
          </div>
        </div>
      <?php endforeach; ?>

      <?php if(!$rows): ?>
        <div class="copyCard" style="grid-column:1/-1;">
          <div class="copyMeta"><div class="ttl">No saved ads yet</div><span class="pillMini">Generate and click “Save”</span></div>
          <div class="copyText">Your saved ads will appear here.</div>
        </div>
      <?php endif; ?>
    </div>
  </section>
</main>
<?php require __DIR__ . '/includes/footer.php'; ?>
