<?php
// app/tools/grant_monthly_credits.php
// Optional cron: grant monthly credits for active subscriptions.
// If you fully rely on Stripe webhooks, you may not need this.
require __DIR__ . '/../includes/bootstrap.php';

$pdo = db();
$now = now_utc();

// Very simple: for users with active subscription, add plan credits if wallet period ended.
// You should refine this to use current_period_start/end from subscriptions.
$stmt = $pdo->prepare("SELECT s.user_id, p.credits_included
                       FROM subscriptions s
                       JOIN plans p ON p.id=s.plan_id
                       WHERE s.status IN ('active','trialing') AND p.is_active=1");
$stmt->execute();
$subs = $stmt->fetchAll();

$granted = 0;
foreach ($subs as $s) {
  $uid = (int)$s['user_id'];
  $credits = (int)$s['credits_included'];
  if ($credits <= 0) continue;

  // For MVP: always grant once per run is dangerous; you must track.
  // We guard by storing a ledger memo "monthly_grant YYYY-MM".
  $memo = 'monthly_grant ' . gmdate('Y-m');
  $chk = $pdo->prepare("SELECT id FROM credit_ledger WHERE user_id=? AND reason='monthly_grant' AND memo=? LIMIT 1");
  $chk->execute([$uid, $memo]);
  if ($chk->fetch()) continue;

  credit_apply_delta($uid, $credits, 'monthly_grant', 'subscription', null, $memo);
  $granted++;
}

echo "Granted monthly credits to {$granted} users\n";
