<?php
// app/tools/purge_trash.php
// Cron daily: deletes assets past purge_after and removes from Bunny storage.
require __DIR__ . '/../includes/bootstrap.php';

$pdo = db();
$now = now_utc();

$stmt = $pdo->prepare("SELECT id, storage_key FROM generation_assets
                       WHERE deleted_at IS NULL AND purge_after IS NOT NULL AND purge_after <= ?
                       LIMIT 500");
$stmt->execute([$now]);
$rows = $stmt->fetchAll();

foreach ($rows as $r) {
  if (!empty($r['storage_key'])) {
    bunny_delete((string)$r['storage_key']);
  }
  $pdo->prepare("UPDATE generation_assets SET deleted_at=? WHERE id=?")->execute([$now, (int)$r['id']]);
}

echo "Purged " . count($rows) . " assets\n";
