<?php
require __DIR__ . '/includes/bootstrap.php';
$user = require_login();
$page_title = 'Usage';
$active = 'usage';
require __DIR__ . '/includes/header.php';
require __DIR__ . '/includes/topbar.php';

$pdo = db();
$balance = wallet_balance((int)$user['id']);

$stmt = $pdo->prepare("SELECT usage_date, generations_count, assets_generated, copy_variants_generated, credits_spent
                       FROM usage_daily WHERE user_id=? ORDER BY usage_date DESC LIMIT 30");
$stmt->execute([(int)$user['id']]);
$usage = $stmt->fetchAll();
?>
<main class="workspace" style="grid-template-columns: 1fr;">
  <section class="canvas">
    <div class="canvasHeader">
      <h1>Usage</h1>
      <div class="topControls">
        <span class="pillMini">Credits: <?= (int)$balance ?></span>
        <a class="btnGhost" style="text-decoration:none;display:inline-flex;align-items:center;" href="<?= htmlspecialchars(app_base()) ?>/create.php">Create Ad</a>
      </div>
    </div>

    <div class="copyCard">
      <div class="copyMeta">
        <div class="ttl">Recent usage (last 30 days)</div>
        <span class="pillMini"><?= count($usage) ?> days</span>
      </div>
      <div class="copyText"><?php
        if(!$usage){
          echo "No usage rows yet. They will populate as you generate ads.\n";
        } else {
          foreach($usage as $u){
            echo sprintf("%s — gens:%d assets:%d copy:%d credits:%d\n",
              $u['usage_date'], $u['generations_count'], $u['assets_generated'], $u['copy_variants_generated'], $u['credits_spent']
            );
          }
        }
      ?></div>
    </div>

    <div class="copyCard">
      <div class="copyMeta">
        <div class="ttl">Billing</div>
        <span class="pillMini">Stripe (wire next)</span>
      </div>
      <div class="copyText">
This build includes DB tables for plans/subscriptions and a webhook folder.
Next steps:
- Add Stripe Checkout + Customer Portal
- Add webhook handler to keep subscriptions in sync
- Grant monthly credits on renewal
      </div>
    </div>
  </section>
</main>
<?php require __DIR__ . '/includes/footer.php'; ?>
